import 'package:flutter/material.dart';
import 'package:zcart_delivery/helper/constants.dart';
import 'package:zcart_delivery/views/custom/custom_container.dart';

class InformationCard extends StatelessWidget {
  final String number;
  final String title;
  const InformationCard({
    Key? key,
    required this.number,
    required this.title,
  }) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return CustomContainer(
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        mainAxisAlignment: MainAxisAlignment.center,
        children: [
          Text(
            title,
            style: Theme.of(context)
                .textTheme
                .titleSmall!
                .copyWith(color: Colors.black54, fontWeight: FontWeight.bold),
          ),
          const SizedBox(height: defaultPadding / 2),
          Text(
            number,
            style: Theme.of(context)
                .textTheme
                .titleLarge!
                .copyWith(fontWeight: FontWeight.bold),
          ),
        ],
      ),
    );
  }
}
